#!/bin/bash
# Author:      Todor T. Zviskov (a.k.a. Warder) - http://warder.ath.cx:81/
# Name:        LNX-patch.sh
# Version:     0.2
# Description: A script to ease the process of applying my favorite linux
#              kernel 2.6.x patches.
# License:     GPL-2 - http://www.gnu.org/licenses/gpl.txt
# 
# Changes:     Moving the kernel tree to reflect the patch version

kver="2.6.13"
kver_final="2.6.13"
kdir="/usr/src"
wd=`pwd`

#mm="2.6.6-mm1"
#mmfix="mmfix.patch"
#bk="patch-2.6.13-rc6"

ck="patch-2.6.13-ck1"
#ck2="patch-O21int-ht4"
#ck3="patch-ht4-batch5"
#ck4="patch-2.6.0-am-5"

#ac="patch-2.6.11-ac4"

libata="2.6.13-rc7-libata1.patch"
#sm="supermount-2.0.4-2.6.12.patch"

lirc="lirc-2.6.9-20040318"
#lirc1="patch-lirc-20030806-test7_fix-bk.diff"

###
### The packet cd writing is now part of the kernel!!!
### packet="packet-2.6.8-2.patch"
###

quickcam="qc-usb-0.6.3.patch"

vt="VT6410.2613.patch"
#usb="usb-NULL.patch"
lnx="patch-LNX"

echo "This script is designed to help you patch your kernel."
if [ `whoami` != "root" ];then
	echo "Please run the script as root."
	exit 1
fi
if [ ! -f "$lnx" ];then
	echo "Please run this script from the directory it's located in, otherwise it won't work. (eg. cd /wherever/this/is; sh LNX-patch.sh)"
	exit 1
fi
echo -ne "Would you like to continue? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "n" ] || [ "$choise" = "N" ];then
	echo "Ok, fine...find a better way to do it."
	exit
fi

echo

if [ ! -d "$kdir/linux-$kver" ];then
	echo "You don't seem to have the kernel $kver sources unpacked in $kdir"
	echo -ne "Do you have linux-$kver.tar.bz2 already downloaded? [y/N]: N\b"
	choise="N"
	read choise
	if [ "$choise" = "y" ] || [ "$choise" = "Y" ];then
		echo -n "Please specily the full path to the file [eg. /home/me]: "
		read ksrcdir
		if [ ! -f "$ksrcdir/linux-$kver.tar.bz2" ];then
			echo "Cannot find $ksrcdir/linux-$kver.tar.bz2"
			echo
			echo "Please check where you put linux-$kver.tar.bz2 and run this script again"
			exit 1
		else
			echo -e "\nUnpacking the kernel source in $kdir..."
			sleep 1
			tar xfj "$ksrcdir"/linux-$kver.tar.bz2 -C $kdir
		fi
	else
		echo
		echo -ne "Would you like to try downloading linux-$kver.tar.bz2? (You have to be connected to the internet and have wget installed) [Y/n] Y\b"
		choise="Y"
		read choise
		if [ "$choise" = "n" ] || [ "$choise" = "N" ];then
			echo
			echo "Ok, download it manually, then restart the script."
			exit 1
		fi
		echo
		echo "Starting download in /tmp..."
		cd /tmp
		wget -c ftp://kernel.org/pub/linux/kernel/v2.6/linux-$kver.tar.bz2
		if [ ! -f linux-$kver.tar.bz2 ];then
			echo "Download was not successful, exitting..."
			cd $wd
			exit 1
		else
			cd $wd
			echo -e "\nUnpacking the kernel source in $kdir..."
			sleep 1
			tar xfj /tmp/linux-$kver.tar.bz2 -C $kdir
		fi
	fi
fi

#echo
#echo -ne "Apply rc1 patch (Recommended)? [Y/n]: Y\b"
#choise="Y"
#read choise
#if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then

# We want -rc3
# 	cd $kdir/linux-$kver
# 	patch -p1 <$wd/$bk
 	#patch -R -p1 <$wd/bk.patch
# 	cd "$wd"
#### 	lirc="patch-lirc-20030802-test7_fix-bk.diff"
#fi

echo

#echo -ne "Apply mm patches (Recommended)? [Y/n]: Y\b"
#echo -ne "Apply mm and ck performance patches (Recommended)? [Y/n]: Y\b"
echo -ne "Apply ck1 patches (Recommended)? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
	cd $kdir/linux-$kver
	#patch -p1 <$wd/$ac
	patch -p1 <$wd/$ck
#	patch -p1 <$wd/$ck2
#	patch -p1 <$wd/$ck3
#	patch -p1 <$wd/$ck4
#	patch -p1 <$wd/$mm
#	patch -R -p1 <$wd/$mmfix
	cd "$wd"
#	packet="packet-2.6.0-test4.patch"
####	lirc="patch-lirc-20030802-test6_fix-mm.diff"
#	sm="supermount-2.0.4-2.6.10-ac7.patch"
#	vt="VT6410.267-ac7.patch"
fi
echo
####else
	echo -ne "Apply jgarzik's libata patch? [Y/n]: Y\b"
	choise="Y"
	read choise
	if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
		cd $kdir/linux-$kver
	        patch -p1 <$wd/$libata
		cd "$wd"
	fi
	echo
####fi

echo

echo -ne "Apply lirc patch? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
	cd $kdir/linux-$kver
#	echo -ne "Do you use lirc-0.7.0_pre2 or later? [y/N]: N\b"
#	choise="N"
#	read choise
#	if [ "$choise" = "y" ] || [ "$choise" = "Y" ];then
#		patch -p1 <$wd/$lirc1
#	else
		patch -p1 <$wd/$lirc
#	fi
	cd "$wd"
fi

echo

### The packet cd writing is now part of the kernel!!!
###
### echo -ne "Apply Packet CD writing patch? [Y/n]: Y\b"
### choise="Y"
### read choise
### if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
### 	cd $kdir/linux-$kver
### 	patch -p1 <$wd/$packet
### 	cd "$wd"
### fi
### echo


echo -ne "Apply Quickcam Express/Web Driver patch? [Y/n]: Y\b"
choise="Y"
read choise
if [ "$choise" = "y" ] || [ "$choise" = "Y" ] || [ "$choise" = "" ];then
	cd $kdir/linux-$kver
	patch -p1 <$wd/$quickcam
	cd "$wd"
fi
echo


echo "Applying LNX patches..."
cd $kdir/linux-$kver
patch -p1 <$wd/$lnx
patch -p1 <$wd/$vt
#patch -p1 <$wd/$usb

echo
echo "Moving kernel tree..."
cd $kdir
mv linux-$kver linux-$kver_final-`cat $wd/patch-LNX |grep "+EXTRAVERSION"|cut -d "-" -f2-`

echo

echo "All Done."
echo "Now compile your kernel, eg. cd $kdir/linux-$kver_final-`cat $wd/patch-LNX |grep "+EXTRAVERSION"|cut -d "-" -f2-`;make menuconfig;make install"

